Imports System
Imports Microsoft.VisualBasic
Imports Optimizer
Imports System.IO

'/***************************************************************************************\
'* Name:        MipSolEnum.vb                                      FairIsaac 13/06/2008 *
'* Purpose:     10 best solutions with the MIP solution enumerator                      *
'* Description: We take the power generation problem stored in hpw15.mps which seeks to *
'*              optimise the operating pattern of a group of electricity generators. We *
'*              run the MIP solution enumerator on the problem using the default setup  *
'*              obtaining the best 10 solutions. The best 10 solutions are stored to a  *
'*              MIP solution pool.  The solutions' objectives and solution values are   *
'*              printed to screen.                                                      *
'* Input:       hpw15.mps                                                               *
'\***************************************************************************************/

Module MipSolEnum
    Public Sub RunMipSolEnum(ByRef Log As TextWriter)
        XPRS.Init("")

        Dim prob As New XPRSprob
        ' Tell Optimizer to send all messages to Log '
        prob.AddMsgHandlerCallback(Log)

        Dim msp As New XPRSmipsolpool
        Dim mse As New XPRSmipsolenum

        prob.ReadProb(frmMain.sDataDirPath & "/hpw15")
        Dim nCols As Integer = prob.Cols

        ' Avoid duplicated solutions from heuristics.
        msp.DuplicateSolutionsPolicy = 3

        ' Disable dual reductions to prevent dominated solutions from being
        ' presolved away.
        prob.MIPDualReductions = 2

        ' Run the enumeration '
        Dim nMaxSols As Integer = 10
        mse.Minim(prob, msp, XPRSdefaultMipSolEnumHandler.GetDefaultHandlerCallback(), Nothing, nMaxSols)

        ' Print out the solutions found
        Dim nSols As Integer = mse.Solutions
        Log.WriteLine("Enumerated best {0} solutions", nSols)
        Dim i As Integer
        For i = 1 To nSols
            Dim iSolutionId(1) As Integer
            Dim dObj As Double
            Dim nSols2, nReturnedSolIds, solutionIdStatus As Integer
            mse.GetSolList(XPRSattribute.Mse_Metric_MipObject, i, i, iSolutionId, nReturnedSolIds, nSols2)
            mse.GetSolMetric(iSolutionId(0), solutionIdStatus, XPRSattribute.Mse_Metric_MipObject, dObj)
            Log.WriteLine("--------")
            Log.WriteLine("{0} = {1}", i, dObj)
            Dim j As Integer
            For j = 0 To nCols - 1
                Dim dSol(1) As Double
                Dim nValuesReturned As Integer
                msp.GetSol(iSolutionId(0), solutionIdStatus, dSol, j, j, nValuesReturned)
                Log.WriteLine("{0} = {1}", j, dSol(0))
            Next

        Next

    End Sub

End Module
