Imports System
Imports Microsoft.VisualBasic
Imports Optimizer
Imports System.IO

'/***************************************************************************************\
'* Name:        MipSolPool.vb                                      FairIsaac 13/06/2008 *
'* Purpose:     All solutions with the MIP solution pool                                *
'* Description: We take the power generation problem stored in hpw15.mps which seeks to *
'*              optimise the operating pattern of a group of electricity generators. We *
'*              solve the problem collecting all solutions found during the MIP search. *
'*              The optimal solution's objective and solution values are printed to     *
'*              screen.                                                                 *
'* Input:       hpw15.mps                                                               *
'\***************************************************************************************/

Module MipSolPool
    Public Sub RunMipSolPool(ByRef Log As TextWriter)
        Try

            XPRS.Init("")

            Dim prob As XPRSprob
            prob = New XPRSprob

            ' Tell Optimizer to send messages to the Log
            prob.AddMsgHandlerCallback(Log)

            Dim msp As New XPRSmipsolpool
            msp.ProbAttach(prob)
            prob.ReadProb(frmMain.sDataDirPath & "/hpw15")

            prob.Minim("g")

            Dim nSols As Integer
            nSols = msp.Solutions
            Log.WriteLine("{0} solutions stored in XPRSmipsolpool", nSols)
            Log.WriteLine()

            If nSols > 0 Then
                Dim iSolutionId As Integer, iSolutionIdStatus As Integer
                Dim dObj As Double
                msp.GetDblAttribProbExtreme(prob, 0, iSolutionId, XPRSattribute.Msp_SolPrb_Obj, dObj)

                Log.WriteLine("Optimal Solution ID: {0}", iSolutionId)
                Log.WriteLine("Optimal Objective  : {0}", dObj)

                Dim nCols As Integer
                nCols = msp.GetIntAttribSol(iSolutionId, iSolutionIdStatus, XPRSattribute.Msp_Sol_Cols)
                Dim i As Integer
                For i = 0 To nCols - 1
                    Dim nValuesReturned As Integer
                    Dim dSol() As Double
                    ReDim dSol(1)
                    msp.GetSol(iSolutionId, iSolutionIdStatus, dSol, i, i, nValuesReturned)
                    Log.WriteLine("{0} = {1}", i, dSol(0))
                Next
            End If

            prob.Destroy()
            msp.Destroy()
            XPRS.Free()
        Catch ex As Exception
            Log.WriteLine(ex.ToString)
        End Try
    End Sub

End Module
