# Example for the use of the Python language (Blending problem).
#
# Data given in the model.
#
# (C) 2018-2025 Fair Isaac Corporation

import xpress as xp

p = xp.problem()

ROres = range(2)
REV = 125                     # Unit revenue of product.
MINGRADE = 4                  # Min permitted grade of product.
MAXGRADE = 5                  # Max permitted grade of product.

COST = [85.00, 93.00]
AVAIL = [60.00, 45.00]
GRADE = [2.1, 6.3]

x = [p.addVariable(ub=AVAIL[o]) for o in ROres]

# Objective: maximize total profit.
p.setObjective(xp.Sum((REV - COST[o]) * x[o] for o in ROres),
               sense=xp.maximize)

# Lower and upper bounds on ore quality.
p.addConstraint(xp.Sum((GRADE[o] - MINGRADE) * x[o] for o in ROres) >= 0)
p.addConstraint(xp.Sum((MAXGRADE - GRADE[o]) * x[o] for o in ROres) >= 0)

p.optimize()
